uniform vec2 center; 
uniform vec2 resolution;
uniform float time;
uniform vec2 mouse; 
uniform float pulse1;
uniform float pulse2;
uniform float pulse3; 






#define SIZE 10.
#define PI 3.1415

#define MOD3 vec3(.1031,.11369,.13787)
float hash12(vec2 p) {
     
	
	vec3 p3  = fract(vec3(p.xyx) * MOD3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

float brightness(vec2 uv, vec2 id) {
    
	float t = time;
    float n = hash12(id);
    float c = mix(0.7, 1., n);				
    
    float x = abs(id.x-SIZE*.5);
    float stripes = sin(x*.65+sin(id.y*.5)+.3)*.5+.5;		
    stripes = pow(stripes, 4.);
    c *= 1.-stripes*.5;
    
    float y = floor(uv.y*SIZE);
    float twinkle = sin(t+n*6.28)*.5 +.5;
    twinkle = pow(twinkle, 40.);
    c += twinkle*.5;                 
    
    return c;
}

float spokes(vec2 uv, float spikeFrequency) {
	
    
    vec2 p = vec2(0., 1.);
    vec2 d = p-uv;
    float l = length(d);
    d /= l;
    
    vec2 up = vec2(1., 0.);
    
    float c = dot(up, d);
    c = abs(sin(c*spikeFrequency));
    c *= l;
    
    return c;
}

vec4 ScaleInfo(vec2 uv, vec2 p, vec3 shape) {
    
    float spikeAmount = shape.x;
    float spikeFrequency = shape.y;
    float sag = shape.z;
    
    uv -= p;
    
    uv = uv*2.-1.;
  	
    float d2 = spokes(uv, spikeFrequency);
    
    uv.x *= 1.+uv.y*sag;
   
	float d1 = dot(uv, uv);					
   
    float threshold = 1.;
    
    float d = d1+d2*spikeAmount;
    
    float f = 0.05;
    float c = smoothstep(threshold, threshold-f, d);
    
    return vec4(d1, d2, d, c);
}

vec4 ScaleCol(vec2 uv, vec2 p, vec4 i) {
    
    vec3 col1 = vec3(.1, .3, .2);
    vec3 col2 = vec3(.8, .5, .2);
    vec3 baseCol = vec3(.1, .3, .2)*3.;
    uv-=p;
    
    float grad = 1.-uv.y;
    float col = grad+i.x;
    col = col*.2+.5;
    
    vec4 c = vec4(col*baseCol, i.a);
    
    c.rgb = mix(c.rgb, col1, i.y*i.x*.5);		
    c.rgb = mix(c.rgb, col2, i.x);				
            
    c = mix(vec4(0.), c, i.a);
    
    float fade = 0.3;
    float shadow = smoothstep(1.+fade, 1., i.z);
  
	c.a = mix(shadow*.25, 1., i.a);
    
    return c;
}


vec4 Scale(vec2 uv, vec2 p, vec3 shape) {
    
    vec4 info = ScaleInfo(uv, p, shape);
    vec4 c = ScaleCol(uv, p, info);
    
    return c;
}

vec4 ScaleTex(vec2 uv, vec2 uv2, vec3 shape) {
    
    
    
    
    
    
    vec2 id = floor(uv2);
    uv2 -= id;
    
    
    vec4 rScale = Scale(uv2, vec2(.5, 0.01), shape);
   	vec4 lScale = Scale(uv2, vec2(-.5, 0.01), shape);
    vec4 bScale = Scale(uv2, vec2(0., -0.5), shape);
    vec4 tScale = Scale(uv2, vec2(0., 0.5), shape);
    vec4 t2Scale = Scale(uv2, vec2(1., 0.5), shape);
    
    
    rScale.rgb *= brightness(uv, id+vec2(1.,0.));
    lScale.rgb *= brightness(uv, id+vec2(0.,0.));
    
    bScale.rgb *= brightness(uv, id+vec2(0.,0.));
    
    tScale.rgb *= brightness(uv, id+vec2(0.,1.));
    t2Scale.rgb *= brightness(uv, id+vec2(2.,1.));
    
    
    vec4 c =  vec4(.1, .3, .2,1.);
    c = mix(c, bScale, bScale.a);
    c = mix(c, rScale, rScale.a);
    c = mix(c, lScale, lScale.a);
    c = mix(c, tScale, tScale.a);
    c = mix(c, t2Scale, t2Scale.a);
    
   
   
    return c;
}

void main(){
    float aspect = resolution.x/resolution.y;
    
	vec2 uv = gl_FragCoord.xy / resolution.xy;  
    vec2 m = mouse.xy/resolution.xy;
    m = m*2. - 1.;
    float t = time;
    
    
    
   	uv.x += sin(t+uv.y)*.1;
    
    uv.x*=2.;
    
    uv -=.5;
    
    
    vec2 uv2 = uv * SIZE;						
    uv2.y -= t;
    uv +=.5;
       
    float grad = (uv2.y+12.5)/15.;				

    vec3 center = vec3(.6, 1., -.8);  			
    vec3 outside = vec3(0.1, 8., -.9);  		
    
    float sideFade = pow(uv.x-1.,2.);
    vec3 shape = mix(center, outside, sideFade);
    
   
    
  
    
    vec4 c = ScaleTex(uv, uv2, shape);			
    c = mix(c, vec4(c.g), sideFade);			
    
    t*=.1;										
    c.r += sin(t)*.4;
    c.g -= abs(sin(t*1.324))*.435;
    c.b += sin(t*0.324)*.3;
    
    float y = pow(uv.y-.5,2.)*4.;				
    c *= 1.-y;
	
    gl_FragColor = vec4(c);
}

